/* global ajaxurl */

var kirki = kirki || {};

kirki = jQuery.extend( kirki, {

	/**

	 * A collection of utility methods.

	 *

	 * @since 3.0.17

	 */

	util: {



		/**

		 * A collection of utility methods for webfonts.

		 *

		 * @since 3.0.17

		 */

		webfonts: {



			/**

			 * Google-fonts related methods.

			 *

			 * @since 3.0.17

			 */

			google: {



				/**

				 * An object containing all Google fonts.

				 *

				 * to set this call this.setFonts();

				 *

				 * @since 3.0.17

				 */

				fonts: {},



				/**

				 * Init for google-fonts.

				 *

				 * @since 3.0.17

				 * @returns {null}

				 */

				initialize: function() {

					var self = this;



					self.setFonts();

				},



				/**

				 * Set fonts in this.fonts

				 *

				 * @since 3.0.17

				 * @returns {null}

				 */

				setFonts: function() {

					var self = this;



					// No need to run if we already have the fonts.

					if ( ! _.isEmpty( self.fonts ) ) {

						return;

					}



					// Make an AJAX call to set the fonts object (alpha).

					jQuery.post( ajaxurl, { 'action': 'kirki_fonts_google_all_get' }, function( response ) {



						// Get fonts from the JSON array.

						self.fonts = JSON.parse( response );

					} );

				},



				/**

				 * Gets all properties of a font-family.

				 *

				 * @since 3.0.17

				 * @param {string} family - The font-family we're interested in.

				 * @returns {Object}

				 */

				getFont: function( family ) {

					var self = this,

					    fonts = self.getFonts();



					if ( 'undefined' === typeof fonts[ family ] ) {

						return false;

					}

					return fonts[ family ];

				},



				/**

				 * Gets all properties of a font-family.

				 *

				 * @since 3.0.17

				 * @param {string} order - How to order the fonts (alpha|popularity|trending).

				 * @param {int}    number - How many to get. 0 for all.

				 * @returns {Object}

				 */

				getFonts: function( order, number ) {

					var self    = this,

					    ordered = {},

					    partial = [];



					// Make sure order is correct.

					order  = order || 'alpha';

					order  = ( 'alpha' !== order && 'popularity' !== order && 'trending' !== order ) ? 'alpha' : order;



					// Make sure number is correct.

					number = number || 0;

					number = parseInt( number, 10 );



					if ( 'alpha' === order || 0 === number ) {

						ordered = self.fonts.items;

					} else {

						partial = _.first( self.fonts.order[ order ], number );

						_.each( partial, function( family ) {

							ordered[ family ] = self.fonts.items[ family ];

						} );

					}



					return ordered;

				},



				/**

				 * Gets the variants for a font-family.

				 *

				 * @since 3.0.17

				 * @param {string} family - The font-family we're interested in.

				 * @returns {Array}

				 */

				getVariants: function( family ) {

					var self = this,

					    font = self.getFont( family );



					// Early exit if font was not found.

					if ( ! font ) {

						return false;

					}



					// Early exit if font doesn't have variants.

					if ( _.isUndefined( font.variants ) ) {

						return false;

					}



					// Return the variants.

					return font.variants;

				},



				/**

				 * Get the subsets for a font-family.

				 *

				 * @since 3.0.17

				 * @param {string} family - The font-family we're interested in.

				 * @returns {Object}

				 */

				getSubsets: function( family ) {

					var self = this,

					    font = self.getFont( family );



					// Early exit if font was not found.

					if ( ! font ) {

						return false;

					}



					// Early exit if font doesn't have subsets.

					if ( _.isUndefined( font.subsets ) ) {

						return false;

					}



					// Return the variants.

					return font.subsets;

				}

			},



			/**

			 * Standard fonts related methods.

			 *

			 * @since 3.0.17

			 */

			standard: {



				/**

				 * An object containing all Standard fonts.

				 *

				 * to set this call this.setFonts();

				 *

				 * @since 3.0.17

				 */

				fonts: {},



				/**

				 * Init for google-fonts.

				 *

				 * @since 3.0.17

				 * @returns {null}

				 */

				initialize: function() {

					var self = this;



					self.setFonts();

				},



				/**

				 * Set fonts in this.fonts

				 *

				 * @since 3.0.17

				 * @returns {null}

				 */

				setFonts: function() {

					var self = this;



					// No need to run if we already have the fonts.

					if ( ! _.isEmpty( self.fonts ) ) {

						return;

					}



					// Make an AJAX call to set the fonts object.

					jQuery.post( ajaxurl, { 'action': 'kirki_fonts_standard_all_get' }, function( response ) {



						// Get fonts from the JSON array.

						self.fonts = JSON.parse( response );

					} );

				},



				/**

				 * Gets the variants for a font-family.

				 *

				 * @since 3.0.17

				 * @returns {Array}

				 */

				getVariants: function( family ) { // jshint ignore: line

					return ['regular', 'italic', '700', '700italic'];

				}

			}

		}

	}

} );

